package openrtb3


type Ext struct{
    SSP string           `json : "ssp"`    //Supplier identification string
    At int               `json: "at, omitempty"`  //Passes additional auction types used by some Suppliers. 
                                        //  0 Indicates that the Supplier did not actually declare an auction type, 501 = Modified First Price, 502 = Modified Second Price
    Ads_txt *Ads_txt     `json: ads_txt,omitempty`
    Google *Google       `json: google,omitempty`
}

type Ads_txt struct{
    Status  int      `json: "status"`  // Suppliers selling relationship with the publisher: 1 = direct, 2 = reseller, 3 = unauthorized
    Auth_id string  `json: "auth_id"`  //Passes the TAG ID if present in the ads.txt file, e.g. "8765jfhfg09j"
    Pub_id  string   `json: "pub_id,omitempty"` //unmodified publisher ID at that Supplier e.g., "123456789".   Note: In the standard Publisher object, BidSwitch passes the publisher.id field including the SSP prefix, e.g. aol_123456789
}


type Google struct{
    Detected_vertical *Detected_vertical `json: "detected_vertical,omitempty"`
}   

type Detected_vertical struct{
    Id int          `json: "id,omitempty"`  //vertical ID as defined by AdX docs, for example, 1014
    Weight float64  `json: "weight,omitempty"`  //Weight for this vertical, in the (0.0, 1.0) range. More relevant verticals have higher weights, for example, 1.0
}